<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>IBSheet7-Product</title>
        <link rel="stylesheet" type="text/css" href="../Sheet/js/css/default/main.css"/>
        <script type="text/javascript" src="../js/common.js"></script>
        <script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
        <script type="text/javascript" src="../Chart/ibchart.js"></script>
        <script type="text/javascript" src="../Chart/ibchartinfo.js"></script>
        <script type="text/javascript" src="../Sheet/js/ibsheet.js"></script>
        <script type="text/javascript" src="../Sheet/js/locale/ko.js"></script>
        <script type="text/javascript">
        	var pageheightoffset = 310;
            var fc = "";
            function PageLoad() {
                init_sheet();

                createIBChart("myChart", "myChart", {
                    width: "100%",
                    height: "45%"
                });

                initChart(myChart, "IBSheet와 연동");

            }
            function init_sheet() {
                var initSheet = {};
                initSheet.Cfg = {SearchMode:2,Page:100};
                initSheet.Def={Row:{CanFormula:1,CalcOrder:"salesPrice,cashPrice,instPrice,cashBudam,instBudam"}};
                initSheet.Cols = [
                    {Header:"모델번호",Type:"Text",Name:"modelNo",RelWidth:1},
                    {Header:"용량",Type:"Text",Name:"qty",RelWidth:1},
                    {Header:"단가(A)",Type:"Int",Name:"price",RelWidth:1,SaveName:"A", Align:"Right"},
                    {Header:"판매가(B)\nA * 1.03 / 100",Type:"Int",Name:"salesPrice",RelWidth:1,Format:"#,##0.00", Align:"Right",Formula:"price*1.03/100"},
                    {Header:"현금구입가(C)\n A * 0.9 / 100",Type:"Int",Name:"cashPrice",RelWidth:1,Format:"#,##0.00", Align:"Right",Formula:"price*0.9/100"},
                    {Header:"할부구입가(D)\nA * 0.93 / 100",Type:"Int",Name:"instPrice",RelWidth:1,Format:"#,##0.00", Align:"Right",Formula:"price*0.93/100"},
                    {Header:"현금부담액\nB-C",Type:"Int",Name:"cashBudam",RelWidth:1,Format:"#,##0.00", Align:"Right",Formula:"salesPrice-cashPrice"},
                    {Header:"할부부담액\nB-D",Type:"Int",Name:"instBudam",RelWidth:1,Format:"#,##0.00", Align:"Right",Formula:"salesPrice-instPrice"}
                ];
                initSheet.Events = {
                    onRenderFirstFinish:function(evtParam){
                        evtParam.sheet.doSearch("sheetData2.jsp");
                    }
                };
                IBSheet.create({
                    id:"mySheet",
                    el:"sheetDiv",
                    options:initSheet
                });
            }
            
            function getTitle(s,r,c) {
                var rows = r.split("|");
                var rtnTitle = "";
                for(var i=0;i<rows.length;i++) {
                    rtnTitle += s.GetCellText(rows[i],c)+"|";
                }
                return rtnTitle.substring(0,rtnTitle.length-1);
            }
            function chartDraw(cnt) {
                var endRow = mySheet.getRowByIndex(cnt);
                try {
                    var	pparam = {
                        datadirection:"vertical"
                        ,datarowcol:["salesPrice","cashBudam","instBudam"]
                        ,legendseriesname: ["판매가","현금부담액","현금부담액"]
                        ,legendtitle:"시트차트테스트4"
                        ,startdatarowcol:mySheet.getFirstRow()
                        ,enddatarowcol:endRow
                        ,labelrowcol:"modelNo"
                        ,startlabelrowcol:mySheet.getFirstRow()
                        ,endlabelrowcol:endRow
                        ,labeldirection:"vertical"
                        ,seriestype:["line", "column", "area"]
                    };
                    SHEET2CHART(mySheet,myChart,pparam);

                    //initChart(myChart, "IBSheet와 연동");
                } catch(e) {
                    alert(e.message);
                }
            }
            function initChart(cObj, tTxt) {
                cObj.setOptions({
                    chart:{
                        type:"column",
                        plotBackgroundColor : "#F7FAFB",
                        plotBorderColor:"#A9AEB1",
                        plotBorderWidth:0.5,
                        stacking:"normal"
                    },
                    title:{
                        text:tTxt,
                        style:{
                            color:"#15498B",
                            fontFamily:"Dotum",
                            fontWeight:"bold"
                        }
                    },
                    yAxis:{
                        title:{
                            text:""
                        }
                    }
                });
            }
        </script>
    </head>
    <body onload="PageLoad()">
        <div class="page_title">
            <span><a class="closeDepth" href="#">closeDepth</a></span>
            <span class="title color_sheet">시트와 연동  > <b>세로방향 데이터 읽기</b></span>
        </div>
        <div class="main_content">
            <div class="exp_product">
                IB Sheet와 연동기능을 확인합니다.
            </div>
            <p class="subtit_chart">기능 버튼</p>
            <div class="ib_function2 border_chart" style="height:30px;padding:5px">
                <table class="ib_column2">
                    <tr>
                        <th class="tit">10건 차트표현</th>
                        <td class="r20">
                            <input type="button" value="그리기" onclick="chartDraw(10)">
                        </td>
                        <th class="tit">50건 차트표현</th>
                        <td class="r20">
                            <input type="button" value="그리기" onclick="chartDraw(50)">
                        </td>
                    </tr>
                </table>
            </div>
              <div class="ib_product">
            <p class="subtit_chart">IB Sheet</p>
                <div id="sheetDiv" style="width:100%;height:45%"></div>
				<p class="subtit_chart">IB Chart</p>

				<div id="myChart"></div>
			</div>


        </div>
    </body>
</html>